/*
 * Decompiled with CFR 0.152.
 */
package ru.betterend.registry;

import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import ru.bclib.api.LifeCycleAPI;
import ru.bclib.api.biomes.BiomeAPI;
import ru.bclib.world.biomes.BCLBiome;
import ru.bclib.world.generator.BiomePicker;
import ru.bclib.world.generator.map.hex.HexBiomeMap;
import ru.betterend.config.Configs;
import ru.betterend.world.biome.EndBiome;
import ru.betterend.world.biome.air.BiomeIceStarfield;
import ru.betterend.world.biome.cave.EmptyAuroraCaveBiome;
import ru.betterend.world.biome.cave.EmptyEndCaveBiome;
import ru.betterend.world.biome.cave.EmptySmaragdantCaveBiome;
import ru.betterend.world.biome.cave.EndCaveBiome;
import ru.betterend.world.biome.cave.JadeCaveBiome;
import ru.betterend.world.biome.cave.LushAuroraCaveBiome;
import ru.betterend.world.biome.cave.LushSmaragdantCaveBiome;
import ru.betterend.world.biome.land.AmberLandBiome;
import ru.betterend.world.biome.land.BlossomingSpiresBiome;
import ru.betterend.world.biome.land.ChorusForestBiome;
import ru.betterend.world.biome.land.CrystalMountainsBiome;
import ru.betterend.world.biome.land.DragonGraveyardsBiome;
import ru.betterend.world.biome.land.DryShrublandBiome;
import ru.betterend.world.biome.land.DustWastelandsBiome;
import ru.betterend.world.biome.land.FoggyMushroomlandBiome;
import ru.betterend.world.biome.land.GlowingGrasslandsBiome;
import ru.betterend.world.biome.land.LanternWoodsBiome;
import ru.betterend.world.biome.land.MegalakeBiome;
import ru.betterend.world.biome.land.MegalakeGroveBiome;
import ru.betterend.world.biome.land.NeonOasisBiome;
import ru.betterend.world.biome.land.PaintedMountainsBiome;
import ru.betterend.world.biome.land.ShadowForestBiome;
import ru.betterend.world.biome.land.SulphurSpringsBiome;
import ru.betterend.world.biome.land.UmbraValleyBiome;
import ru.betterend.world.biome.land.UmbrellaJungleBiome;
import ru.betterend.world.generator.BiomeType;
import ru.betterend.world.generator.GeneratorOptions;

public class EndBiomes {
    public static final BiomePicker CAVE_BIOMES = new BiomePicker();
    private static HexBiomeMap caveBiomeMap;
    private static long lastSeed;
    public static final EndBiome FOGGY_MUSHROOMLAND;
    public static final EndBiome CHORUS_FOREST;
    public static final EndBiome DUST_WASTELANDS;
    public static final EndBiome MEGALAKE;
    public static final EndBiome MEGALAKE_GROVE;
    public static final EndBiome CRYSTAL_MOUNTAINS;
    public static final EndBiome PAINTED_MOUNTAINS;
    public static final EndBiome SHADOW_FOREST;
    public static final EndBiome AMBER_LAND;
    public static final EndBiome BLOSSOMING_SPIRES;
    public static final EndBiome SULPHUR_SPRINGS;
    public static final EndBiome UMBRELLA_JUNGLE;
    public static final EndBiome GLOWING_GRASSLANDS;
    public static final EndBiome DRAGON_GRAVEYARDS;
    public static final EndBiome DRY_SHRUBLAND;
    public static final EndBiome LANTERN_WOODS;
    public static final EndBiome NEON_OASIS;
    public static final EndBiome UMBRA_VALLEY;
    public static final EndBiome ICE_STARFIELD;
    public static final EndCaveBiome EMPTY_END_CAVE;
    public static final EndCaveBiome EMPTY_SMARAGDANT_CAVE;
    public static final EndCaveBiome LUSH_SMARAGDANT_CAVE;
    public static final EndCaveBiome EMPTY_AURORA_CAVE;
    public static final EndCaveBiome LUSH_AURORA_CAVE;
    public static final EndCaveBiome JADE_CAVE;

    public static void register() {
        LifeCycleAPI.onLevelLoad(EndBiomes::onWorldLoad);
    }

    private static void onWorldLoad(class_3218 level, long seed, class_2378<class_1959> registry) {
        CAVE_BIOMES.getBiomes().forEach(biome -> biome.updateActualBiomes(registry));
        CAVE_BIOMES.rebuild();
        if (caveBiomeMap == null || lastSeed != seed) {
            caveBiomeMap = new HexBiomeMap(seed, GeneratorOptions.getBiomeSizeCaves(), CAVE_BIOMES);
            lastSeed = seed;
        }
    }

    public static EndBiome registerSubBiome(EndBiome.Config biomeConfig, EndBiome parent) {
        EndBiome biome = EndBiome.create(biomeConfig);
        if (Configs.BIOME_CONFIG.getBoolean(biome.getID(), "enabled", true)) {
            BiomeAPI.registerSubBiome((BCLBiome)parent, (BCLBiome)biome);
        }
        return biome;
    }

    public static EndBiome registerBiome(EndBiome.Config biomeConfig, BiomeType type) {
        EndBiome biome = EndBiome.create(biomeConfig);
        if (Configs.BIOME_CONFIG.getBoolean(biome.getID(), "enabled", true)) {
            if (type == BiomeType.LAND) {
                BiomeAPI.registerEndLandBiome((BCLBiome)biome);
            } else {
                BiomeAPI.registerEndVoidBiome((BCLBiome)biome);
            }
        }
        return biome;
    }

    public static EndBiome registerSubBiomeIntegration(EndBiome.Config biomeConfig) {
        EndBiome biome = EndBiome.create(biomeConfig);
        if (Configs.BIOME_CONFIG.getBoolean(biome.getID(), "enabled", true)) {
            BiomeAPI.registerBiome((BCLBiome)biome);
        }
        return biome;
    }

    public static void addSubBiomeIntegration(EndBiome biome, class_2960 parent) {
        BCLBiome parentBiome;
        if (Configs.BIOME_CONFIG.getBoolean(biome.getID(), "enabled", true) && (parentBiome = BiomeAPI.getBiome((class_2960)parent)) != null && !parentBiome.containsSubBiome((BCLBiome)biome)) {
            parentBiome.addSubBiome((BCLBiome)biome);
        }
    }

    public static EndCaveBiome registerCaveBiome(EndCaveBiome.Config biomeConfig) {
        EndCaveBiome biome = EndCaveBiome.create(biomeConfig);
        if (Configs.BIOME_CONFIG.getBoolean(biome.getID(), "enabled", true)) {
            BiomeAPI.registerBiome((BCLBiome)biome);
            CAVE_BIOMES.addBiome((BCLBiome)biome);
        }
        return biome;
    }

    public static EndCaveBiome getCaveBiome(int x, int z) {
        return (EndCaveBiome)caveBiomeMap.getBiome((double)x, 5.0, (double)z);
    }

    static {
        FOGGY_MUSHROOMLAND = EndBiomes.registerBiome(new FoggyMushroomlandBiome(), BiomeType.LAND);
        CHORUS_FOREST = EndBiomes.registerBiome(new ChorusForestBiome(), BiomeType.LAND);
        DUST_WASTELANDS = EndBiomes.registerBiome(new DustWastelandsBiome(), BiomeType.LAND);
        MEGALAKE = EndBiomes.registerBiome(new MegalakeBiome(), BiomeType.LAND);
        MEGALAKE_GROVE = EndBiomes.registerSubBiome(new MegalakeGroveBiome(), MEGALAKE);
        CRYSTAL_MOUNTAINS = EndBiomes.registerBiome(new CrystalMountainsBiome(), BiomeType.LAND);
        PAINTED_MOUNTAINS = EndBiomes.registerSubBiome(new PaintedMountainsBiome(), DUST_WASTELANDS);
        SHADOW_FOREST = EndBiomes.registerBiome(new ShadowForestBiome(), BiomeType.LAND);
        AMBER_LAND = EndBiomes.registerBiome(new AmberLandBiome(), BiomeType.LAND);
        BLOSSOMING_SPIRES = EndBiomes.registerBiome(new BlossomingSpiresBiome(), BiomeType.LAND);
        SULPHUR_SPRINGS = EndBiomes.registerBiome(new SulphurSpringsBiome(), BiomeType.LAND);
        UMBRELLA_JUNGLE = EndBiomes.registerBiome(new UmbrellaJungleBiome(), BiomeType.LAND);
        GLOWING_GRASSLANDS = EndBiomes.registerBiome(new GlowingGrasslandsBiome(), BiomeType.LAND);
        DRAGON_GRAVEYARDS = EndBiomes.registerBiome(new DragonGraveyardsBiome(), BiomeType.LAND);
        DRY_SHRUBLAND = EndBiomes.registerBiome(new DryShrublandBiome(), BiomeType.LAND);
        LANTERN_WOODS = EndBiomes.registerBiome(new LanternWoodsBiome(), BiomeType.LAND);
        NEON_OASIS = EndBiomes.registerSubBiome(new NeonOasisBiome(), DUST_WASTELANDS);
        UMBRA_VALLEY = EndBiomes.registerBiome(new UmbraValleyBiome(), BiomeType.LAND);
        ICE_STARFIELD = EndBiomes.registerBiome(new BiomeIceStarfield(), BiomeType.VOID);
        EMPTY_END_CAVE = EndBiomes.registerCaveBiome(new EmptyEndCaveBiome());
        EMPTY_SMARAGDANT_CAVE = EndBiomes.registerCaveBiome(new EmptySmaragdantCaveBiome());
        LUSH_SMARAGDANT_CAVE = EndBiomes.registerCaveBiome(new LushSmaragdantCaveBiome());
        EMPTY_AURORA_CAVE = EndBiomes.registerCaveBiome(new EmptyAuroraCaveBiome());
        LUSH_AURORA_CAVE = EndBiomes.registerCaveBiome(new LushAuroraCaveBiome());
        JADE_CAVE = EndBiomes.registerCaveBiome(new JadeCaveBiome());
    }
}

